﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="Soneta.Core.DbTuples" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Workflow.Dms" %>
<%@ Import Namespace="Soneta.Workflow.Workers" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Metryka sprawy</title> 
    <script runat="server">

    void dc_ContextLoad(object sender, EventArgs args)
    {
        var matter = (Matter) dc.Context[typeof(Matter)];

        var worker = new MatterCaseWorker
        {
            Matter = matter
        };

        ReportHeader["DATE"] = worker.RegistrationDatetime;
        ReportHeader["TITLE"] = worker.Title;
        ReportHeader["NUMBER"] = worker.Number;
        Grid1.DataSource = worker.MatterCaseChangeInfos;
    }

    private void Grid_BeforeRow(object sender, RowEventArgs args)
    {
        var matterCaseChangeInfo = (MatterCaseChangeInfo) args.Row;

        colDateTime.EditValue = matterCaseChangeInfo.DateTime;
        colResponsible.EditValue = matterCaseChangeInfo.Responsible;
        colTakenAction.EditValue = matterCaseChangeInfo.TakenAction;
        colRowDescription.EditValue = matterCaseChangeInfo.RowDescription;
    }

    </script>
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader id="ReportHeader" title="METRYKA SPRAWY|<span style='font-size: 7pt;'>Oznaczenie sprawy: %DATE%|<span style='font-size: 7pt;'>Tytuł sprawy: %TITLE%|<span style='font-size: 7pt;'>Numer sprawy: %NUMBER%" runat="server" ></eb:ReportHeader>
        <ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Workflow.Dms.Matter" OnBeforeRow="Grid_BeforeRow">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="10" Align="Left" ID="colDateTime" Caption="Data podjętej czynności" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Width="30" Align="Left" ID="colResponsible" Caption="Oznaczenie osoby podejmującej daną czynność" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Align="Left" ID="colTakenAction" Caption="Określenie podejmowanej czynności" EncodeHTML="True" runat="server"></ea:GridColumn>
                <ea:GridColumn Align="Left" ID ="colRowDescription" Caption="Wskazanie identyfikatora dokumentu w aktach sprawy, do którego odnosi się dana czynność" EncodeHTML="True" runat="server"></ea:GridColumn>
           </Columns>
        </ea:Grid>
        <eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
    </form>
</body>
</html>

